local arrowsStandard = THEME:GetMetric("Player","ReceptorArrowsYStandard");
local arrowsReversed = THEME:GetMetric("Player","ReceptorArrowsYReverse")
local fieldHeight = arrowsReversed - arrowsStandard;

local function DrawArrows(pn)
	local currentGame = GAMESTATE:GetCurrentGame():GetName();

	local arrowsAndLocations = {
		dance = {
			Left  = -96,
			Up    = -32,
			Down  = 32,
			Right = 96,
		},

		pump = {
			DownLeft = -100,
			UpLeft = -50,
			Center = 0,
			UpRight = 50,
			DownRight = 100,
		},

		para = {
			Left = -108,
			UpLeft = -54,
			Up = 0,
			UpRight = 54,
			Right = 108,
		},
	};

	local ret = Def.ActorFrame{
		InitCommand=function(self)
			self:x( THEME:GetMetric("ScreenGameplay","Player".. pname(pn) .."OnePlayerOneSideX") );
			self:y( (SCREEN_CENTER_X+arrowsStandard)/2 );
		end;
	};

	for button,location in ipairs( arrowsAndLocations[ string.lower(currentGame) ] ) do
		ret[#ret+1] = NOTESKIN:LoadActorForNoteSkin( tostring(button), "Go Receptor", "default" )..{
			InitCommand=cmd(x,location);
		};
	end;

	return ret;
end;

local t = Def.ActorFrame{
	-- draw arrows for fun
	DrawArrows(PLAYER_1);
	DrawArrows(PLAYER_2);
};

return t;